/*
	The core of the system is the menu container, which contains all the menus
	currently being displayed. Then below that are menus, which contain their children
	which make up a menu. Children are each option on a menu
*/

const STYLE_VERTICAL = 0
const STYLE_HORIZONTAL = 1

function menu_oContainer(player_starting_menu)
{
	this.menus = new Array()
	
	this.player_menu = player_starting_menu
	
	this.on = false
	
	this.Update = function UpdateMenuContainer()
		{
			if (this.on)
				{
					for (var i = 0; i < this.menus.length; i++)
						{
							if (i == this.player_menu)
								this.menus[i].selected = true
							else
								{ this.menus[i].selected = false }
							this.menus[i].Update(this)		
						
						}
				}
													
		}	
	
	this.Render = function RenderMenuContainer()
		{
			if (this.on)
				{
					for (var i = 0; i < this.menus.length; i++)
						this.menus[i].Render(this)
				}
		}
}

function menu_oMenu(x, y, style, window, Update, Render)
{
	this.children = new Array()
	
	this.x = x
	this.y = y
	this.w = 0
	this.h = 0
	
	this.style = style
	this.window = LoadWindowStyle(window)
	this.spacing = 2
	this.selected = false
	this.choice = 0
	
	this.Update = Update
	this.Render = Render
	
	this.AddChild = function AddChild(child)
		{
			child.UpdateWidthHeight();
			
			if (this.style == STYLE_VERTICAL)
				{
					child.x = 0
					child.y = this.getCombinedY()+this.spacing
				}
				
			if (this.style == STYLE_HORIZONTAL)
				{
					child.x = this.getCombinedX()+this.spacing
					child.y = 0					
				}				
			
			this.children.push( child )	

			if (this.style == STYLE_VERTICAL)
				{
					this.w = this.getBiggestX()
					this.h = this.getCombinedY()+this.spacing				
				}
				
			if (this.style == STYLE_HORIZONTAL)
				{
					this.w = this.getCombinedX()+this.spacing
					this.h = this.getBiggestY()				
				}			
			
			
		}
		
	this.UpdateAll = function UpdateAll()
		{
			var child = this.children
			
			this.children = new Array()
		
			for (var i = 0; i < child.length; i++)
				{
					child[i].UpdateWidthHeight();
			
					if (this.style == STYLE_VERTICAL)
						{
							child[i].x = 0
							child[i].y = this.getCombinedY()+this.spacing
						}
						
					if (this.style == STYLE_HORIZONTAL)
						{
							child[i].x = this.getCombinedX()+this.spacing
							child[i].y = 0					
						}				
					
					this.children.push( child[i] )	
		
					if (this.style == STYLE_VERTICAL)
						{
							this.w = this.getBiggestX()
							this.h = this.getCombinedY()+this.spacing				
						}
						
					if (this.style == STYLE_HORIZONTAL)
						{
							this.w = this.getCombinedX()+this.spacing
							this.h = this.getBiggestY()				
						}		
				}	
		}
	
	this.ChoiceForward = function ChoiceForward()
		{
			var i = this.choice+1
			while (i > this.children.length-1 || !this.children[i].selectable)
				{
					i++;
					if (i > this.children.length-1) i = 0;
					
				}
			this.choice = i
		}
		
	this.ChoiceBackward = function ChoiceBack()
		{
			var i = this.choice-1
			while (i < 0 || !this.children[i].selectable)
				{
					if (i < 0) i = this.children.length;
					i--;
				}
			this.choice = i
		}
		
	this.getCombinedX = function getCombinedX()	
		{
		
			var x = 0
		
			for (var i = 0; i < this.children.length; i++)
				{
					x += this.children[i].w
				}
				
			return x
		
		}
		
	this.getCombinedY = function getCombinedY()
		{
	
			var y = 0
		
			for (var i = 0; i < this.children.length; i++)
				{
					y += this.children[i].h
				}
				
			return y
		
		}
		
	this.getBiggestX = function getCombinedX()	
		{
		
			var x = 0
		
			for (var i = 0; i < this.children.length; i++)
				{
					if (this.children[i].w > x) x = this.children[i].w
				}
				
			return x
		
		}
		
	this.getBiggestY = function getCombinedY()
		{
	
			var y = 0
		
			for (var i = 0; i < this.children.length; i++)
				{
					if (this.children[i].h > y) y = this.children[i].h
				}
				
			return y
		
		}		
}

function menu_oChild_ShakeyText(text)
{

	this.x = 0
	this.y = 0
	this.w = 0
	this.h = 0
	this.text = text
	
	this.selectable = false
	
	this.Update = function UpdateText(parent)
		{
		
		}
	this.Render = function RenderText(parent)
		{
			font.drawZoomedText(this.x+parent.x+Random(-1,1), this.y+parent.y+Random(-1,1), 3, this.text)
		}
		
	this.UpdateWidthHeight = function UpdateWidthHeight()
		{
			this.w = font.getStringWidth(this.text)*3
			this.h = font.getHeight()*3
		}
}

function menu_oChild_Text(text)
{

	this.x = 0
	this.y = 0
	this.w = 0
	this.h = 0
	this.text = text
	
	this.selectable = false
	
	this.Update = function UpdateText(parent)
		{
		
		}
	this.Render = function RenderText(parent)
		{
			font.drawText(this.x+parent.x, this.y+parent.y, this.text)
		}
		
	this.UpdateWidthHeight = function UpdateWidthHeight()
		{
			this.w = font.getStringWidth(this.text)
			this.h = font.getHeight()
		}
}

function menu_oChild_TextBox(text, w)
{

	this.x = 0
	this.y = 0
	this.w = w
	this.h = 0
	this.text = text
	
	this.selectable = false
	
	this.Update = function UpdateText(parent)
		{
		
		}
	this.Render = function RenderText(parent)
		{
			font.drawTextBox(this.x+parent.x, this.y+parent.y, this.w, this.h, 2, this.text)
		}
		
	this.UpdateWidthHeight = function UpdateWidthHeight()
		{
			//this.w = font.getStringWidth(this.text)
			this.h = font.getStringHeight(this.text, this.w)
		}
}

function menu_oChild_Image(image)
{

	this.x = 0
	this.y = 0
	this.w = 0
	this.h = 0
	this.img = image
	this.window = true
	
	this.selectable = false
	
	this.Update = function UpdateText(parent)
		{
		
		}
	this.Render = function RenderText(parent)
		{
			//font.drawText(this.x+parent.x, this.y+parent.y, this.text)
			this.img.blit(this.x+parent.x, this.y+parent.y)
		}
		
	this.UpdateWidthHeight = function UpdateWidthHeight()
		{
			this.w = this.img.width
			this.h = this.img.height
		}
}

function menu_oChild_ScrollImage(image)
{

	this.x = 0
	this.y = 0
	this.w = 0
	this.h = 0
	this.pos = 0
	this.img = image
	
	this.selectable = false
	
	this.Update = function UpdateText(parent)
		{
			this.pos++
			if (this.pos >= 320) this.pos = 0;
		}
	this.Render = function RenderText(parent)
		{
			//font.drawText(this.x+parent.x, this.y+parent.y, this.text)
			this.img.blit(this.x+parent.x+this.pos-320, this.y+parent.y)
			this.img.blit(this.x+parent.x+this.pos, this.y+parent.y)
		}
		
	this.UpdateWidthHeight = function UpdateWidthHeight()
		{
			this.w = this.img.width
			this.h = this.img.height
		}
}

function menu_oChild_Option(text, action)
{

	this.x = 0
	this.y = 0
	this.w = 0
	this.h = 0
	this.text = text
	this.action = action
	
	this.selectable = true
	this.selected = false
	
	this.Update = function UpdateOption(parent, grandparent)
		{
			if (this.selected)
				{
					while ( AreKeysLeft() )
						{
							switch (GetKey())
								{
									case k_up:
										parent.ChoiceBackward()
									break; case k_down:
										parent.ChoiceForward()
									break; case k_left:
										parent.ChoiceBackward()
									break; case k_right:
										parent.ChoiceForward()
									break; case k_a:
										this.action(this, parent, grandparent);
									break;
								}
						}			
				}
		}
	this.Render = function RenderOption(parent, grandparent)
		{
			if (!this.selected) 
				{
					font.drawText(this.x+parent.x, this.y+parent.y, this.text)
				}
			else 
				{
					font.setColorMask(gColor_Red)
					font.drawText(this.x+parent.x, this.y+parent.y, this.text) 
					font.setColorMask(gColor_White)
				}
			if (!this.selectable)
				{
					font.setColorMask(gColor_Gray)
					font.drawText(this.x+parent.x, this.y+parent.y, this.text) 
					font.setColorMask(gColor_White)					
				}
		}
		
	this.UpdateWidthHeight = function UpdateWidthHeight()
		{
			if (this.text != "")
				{
					this.w = font.getStringWidth(this.text)
					this.h = font.getHeight()
				}
			else
				{
					this.w = 0;
					this.h = 0
				}
		}
}

function menu_oChild_Mushrooms(type, quantity, action)
{

	this.x = 0
	this.y = 0
	this.w = 0
	this.h = 0
	this.img = GetMushroomTypePicture(type)
	//this.type = type
	
	this.quantity = quantity
	this.action = action
	
	this.selectable = true
	this.selected = false
	
	this.Update = function UpdateOption(parent, grandparent)
		{
			if (this.selected)
				{
					while ( AreKeysLeft() )
						{												
							switch (GetKey())
								{
									case k_up:
										parent.ChoiceBackward()
									break; case k_down:
										parent.ChoiceForward()
									break; case k_left:
										parent.ChoiceBackward()
									break; case k_right:
										parent.ChoiceForward()
									break; case k_a:
										this.action(this, parent, grandparent);
									break;
								}
						}										
				}
		}
	this.Render = function RenderOption(parent, grandparent)
		{
			GetImage(this.img).blit(this.x+parent.x, this.y+parent.y)
			font.drawText(this.x+parent.x, this.y+parent.y+5, this.quantity)

			if (this.selected == true)
				{
					GetImage("selected.png").blit(this.x+parent.x, this.y+parent.y)
				}

		}
		
	this.UpdateWidthHeight = function UpdateWidthHeight()
		{
			this.w = GetImage(this.img).width
			this.h = GetImage(this.img).height
		}
}

function menu_oChild_SwapMushrooms(type, quantity, action)
{

	this.x = 0
	this.y = 0
	this.w = 0
	this.h = 0
	this.img = GetMushroomTypePicture(type)
	this.quantity = quantity
	this.action = action
	
	this.selectable = true
	this.selected = false
	
	this.Update = function UpdateOption(parent, grandparent)
		{
			if (this.selected)
				{
					while ( AreKeysLeft() )
						{
							switch (GetKey())
								{
									case k_up:
										parent.ChoiceBackward()
									break; case k_down:
										parent.ChoiceForward()
									break; case k_left:
										if (grandparent.player_menu == 3)
											grandparent.player_menu = 4;
										else
											{ grandparent.player_menu = 3 }
									break; case k_right:
										if (grandparent.player_menu == 3)
											grandparent.player_menu = 4;
										else
											{ grandparent.player_menu = 3 }
									break; case k_a:
										this.action(this, parent, grandparent);
									break;
								}
						}		
						
					if (gMenuContainer.menus[5] != undefined)
						{
								//Abort("A")
								var stats = GetMushroomStats(new ItemBuild_oBlock(0, 0,GetMushroomType(this.img)))
							
								gMenuContainer.menus[5].children[0].text = "Durability: "+stats.hp
								gMenuContainer.menus[5].children[1].text = "Cannon: "+stats.cannon
								gMenuContainer.menus[5].children[2].text = "Speed: "+stats.speed
								gMenuContainer.menus[5].children[3].text = "Accuracy: "+stats.accuracy
								gMenuContainer.menus[5].children[4].text = "Value: "+stats.value
								
								gMenuContainer.menus[5].UpdateAll()
						}									
				}
		}
	this.Render = function RenderOption(parent, grandparent)
		{
			GetImage(this.img).blit(this.x+parent.x, this.y+parent.y)
			font.drawText(this.x+parent.x, this.y+parent.y+5, this.quantity)

			if (this.selected == true)
				{
					GetImage("selected.png").blit(this.x+parent.x, this.y+parent.y)
				}

		}
		
	this.UpdateWidthHeight = function UpdateWidthHeight()
		{
			this.w = GetImage(this.img).width
			this.h = GetImage(this.img).height
		}
}

var gMenuContainer = new menu_oContainer(0,0)

function MenuTest()
{
	gMenuContainer.on = true
	
	gMenuContainer.menus.push( new menu_oMenu(40, 40, STYLE_VERTICAL, "style.rws", BasicMenuUpdate, BasicMenuRender) )
	//gMenuContainer.menus.push( new menu_oMenu(40, 40, STYLE_VERTICAL, "style.rws", BasicMenuUpdate, BasicMenuRender) )
	
	gMenuContainer.menus[0].AddChild( new menu_oChild_Option("test", DoNothing) )
	gMenuContainer.menus[0].AddChild( new menu_oChild_Option("test", DoNothing) )
	gMenuContainer.menus[0].AddChild( new menu_oChild_Option("test", DoNothing) )
	
	UProcList.push(UpdateMenus)
	RProcList.push(RenderMenus)
}

function RenderMenus()
{
	gMenuContainer.Render()
}

function UpdateMenus()
{
	gMenuContainer.Update()
}

function BasicMenuRender(parent)
{
	this.window.drawWindow(this.x, this.y, this.w, this.h)
	
	for (var i = 0; i < this.children.length; i++)
		this.children[i].Render(this, parent)
}

function NoWindowMenuRender(parent)
{
	//this.window.drawWindow(this.x, this.y, this.w, this.h)
	
	for (var i = 0; i < this.children.length; i++)
		this.children[i].Render(this, parent)
}

function BasicMenuUpdate(parent)
{
	for (var i = 0; i < this.children.length; i++)
		{
			if (this.selected == true && i == this.choice)
				this.children[i].selected = true
			else
				{ this.children[i].selected = false }		
				
			if (this.selected == true && this.children[this.choice].selectable == false)
				{
					this.ChoiceForward()
				}
				
			this.children[i].Update(this, parent)	
			
		}
}